//
//  MCReportLayoutDefines.h
//  Composer
//
//  Created by Alykhan Jetha on 09/06/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


enum {
    NoKnob = 0,
    UpperLeftKnob,
    UpperMiddleKnob,
    UpperRightKnob,
    MiddleLeftKnob,
    MiddleRightKnob,
    LowerLeftKnob,
    LowerMiddleKnob,
    LowerRightKnob,
};

enum {
    NoKnobsMask = 0,
    UpperLeftKnobMask = 1 << UpperLeftKnob,
    UpperMiddleKnobMask = 1 << UpperMiddleKnob,
    UpperRightKnobMask = 1 << UpperRightKnob,
    MiddleLeftKnobMask = 1 << MiddleLeftKnob,
    MiddleRightKnobMask = 1 << MiddleRightKnob,
    LowerLeftKnobMask = 1 << LowerLeftKnob,
    LowerMiddleKnobMask = 1 << LowerMiddleKnob,
    LowerRightKnobMask = 1 << LowerRightKnob,
    AllKnobsMask = 0xffffffff,
};

enum {
    MCRNoImageTypeCode = 0,
    MCRStaticImageTypeCode,
    MCRImageFilePathFromKeyTypeCode,
    MCRAbsoluteImageFilePathTypeCode,
    MCRImageDataFromKeyTypeCode,
    MCRNamedImageTypeCode,
	MCRNameMapImageTypeCode,
	MCREmbeddedFileImageTypeCode,
	MCRAppEmbeddedFileImageTypeCode,
};

typedef enum {
	MCRNoElementStateWarning = 0,
	MCRKeypathInvalidElementStateWarning = 10,
} MCRElementStateWarning;



#define MCRL_HALF_HANDLE_WIDTH 4.0
#define MCRL_HANDLE_WIDTH 8.0
#define MCRL_HALF_HANDLE_HEIGHT 4.0
#define MCRL_HANDLE_HEIGHT 8.0


extern NSString *MCReportLayoutSelectionChangedNotification;
extern NSString *MCReportLayoutForcedSelectionNotification;
